<?xml version='1.0' encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl= "http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:template match="/">
  <html>
   <head>
     <title>XSL-Beispiel</title>
   <style>
     .bold  { font-weight: bold; }
     .boldlime  { font-weight: bold; 
                  background-color: lime; }
     .lime   { background-color: lime;   }
     .yellow { background-color: yellow; }
     .table  { background-color: silver; }
   </style>
   </head>
   <body>
    <p class="bold">Namensliste gefiltert nach Meier</p>
    <table border="1" bgcolor="silver">
     <tr class="bold">
      <td>Name</td>
      <td>Vorname</td>
      <td>Tel.Nr.</td>
     </tr> <!-- alle Personen, sortiert -->
     <xsl:for-each select="daten/person">
      <xsl:sort select="name" />
      <xsl:sort select="vorname" order="descending" />
      <xsl:if test="name[.='Meier']"> <!-- filtere "Meier" -->
       <tr>
        <td class="boldlime">
         <xsl:value-of select="name"/>
        </td>
        <td class="lime">
         <xsl:value-of select="vorname"/>
        </td>
        <td class="yellow">
         <xsl:value-of select="tel"/>
        </td>
       </tr>
      </xsl:if>
     </xsl:for-each> 	
    </table>
   </body>
  </html>  
</xsl:template>
</xsl:stylesheet>