<?xml version='1.0' encoding="ISO-8859-1"?>
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!-- erste Vorlage mit Tabellenrumpf-->
<xsl:template match="/">
  <html>
   <head>
    <title>XSL-Beispiel</title>
    <style>
     .bold  { font-weight: bold; }
     .boldlime  { font-weight: bold; 
                  background-color: lime; }
     .lime   { background-color: lime;   }
     .yellow { background-color: yellow; }
     .table  { background-color: silver; }
    </style>
   </head>
   <body>
    <p><b>Namensliste aus XML-Dokument</b></p>
    <table border="1" class="table">
     <tr class="bold">
      <td>Name</td>
      <td>Vorname</td>
      <td>Tel.Nr.</td>
     </tr> <!-- alle Personen -->
     <xsl:apply-templates />
    </table>
   </body>
  </html>  
</xsl:template>

<!-- Vorlage fr daten/person-Elemente -->
<xsl:template match="daten/person">
 <tr>
  <xsl:call-template name="name" />
  <xsl:call-template name="vorname" />
  <xsl:call-template name="tel" />
 </tr>
</xsl:template>

<!-- Vorlage fr Zellen mit Namen -->
<xsl:template name="name">
    <td class="boldlime">
      <xsl:value-of select="name" />
    </td>
</xsl:template>

<!-- Vorlage fr Zellen mit Vornamen -->
<xsl:template name="vorname">
    <td class="lime">
     <xsl:value-of select="vorname"/>
    </td>
</xsl:template>

<!-- Vorlage fr Zellen mit Tel-Nr. -->
<xsl:template name="tel">
    <td class="yellow">
      <xsl:value-of select="tel" />
    </td>
</xsl:template>
</xsl:stylesheet>
