<?xml version='1.0' encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl= "http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:template match="/">
  <html>
   <head>
     <title>XSL-Beispiel</title>
   <style>
     .bold  { font-weight: bold; }
     .boldlime  { font-weight: bold; 
                  background-color: lime; }
     .lime   { background-color: lime;   }
     .yellow { background-color: yellow; }
     .table  { background-color: silver; }
   </style>
   </head>
   <body>
    <p class="bold">Personenliste mit Altersauswertung</p>
    <table border="1" class="table">
     <tr class="bold">
      <td>Name</td>
      <td>Vorname</td>
      <td>Tel.Nr.</td>
      <td>Alter</td>
     </tr>
     <!-- alle Datenstze -->
     <xsl:for-each select="daten/person" >
      <xsl:sort select="name" />
      <xsl:sort select="vorname" />
      <tr>
       <xsl:apply-templates />
      </tr> 
     </xsl:for-each>

     <!-- filtere alle Personen >= 30 Jahre -->
     <tr class="bold">
      <td colspan="4">lter als 30</td>
     </tr>
     <xsl:for-each select="daten/person">
      <xsl:if test="alter[.  >= 30]">
       <tr>
        <xsl:apply-templates />
       </tr> 
      </xsl:if>
     </xsl:for-each>

     <!-- filtere alle Personen <= 30 Jahre -->
     <tr class="bold">
      <td colspan="4">jnger als als 30</td>
     </tr>
     <xsl:for-each select="daten/person">
      <xsl:if test="alter[.  &lt;= 30]">
       <tr>
        <xsl:apply-templates />
       </tr> 
      </xsl:if>
     </xsl:for-each>

    </table>
   </body>
  </html>  
</xsl:template>

<!-- Vorlagen fr Zellen mit Einzeldaten -->
<xsl:template match="name">
  <td class="boldlime">
   <xsl:value-of select="." />
  </td>
</xsl:template>

<xsl:template match="vorname">
  <td class="boldlime">
   <xsl:value-of select="." />
  </td>
</xsl:template>

<xsl:template match="tel">
  <td class="yellow">
   <xsl:value-of select="." />
  </td>
</xsl:template>

<xsl:template match="alter">
  <td class="yellow">
   <xsl:value-of select="." />
  </td>
</xsl:template>

</xsl:stylesheet>