<?xml version='1.0' encoding="ISO-8859-1"?>
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:template match="/|*">
<html>
<head><title>XPath - Axis</title>
<style>
    hr { width: 90%; }
    body { background-color: #fcf0fc; }
    .bold   { font-weight: bold; }
    .table  { background-color: silver; }
    .lime   { background-color: lime;   }
    .yellow { background-color: yellow; }
    .aqua   { background-color: aqua; }
</style>
</head>
<body>
<h2>XPath - Beispiele fr Axis</h2>
<h4>Einfache Ausdrcke</h4>
 <b>/daten/person[1]/name</b>: <xsl:value-of select="/daten/person[1]/name" /><br />
 <b>/daten/person[1]/child::name</b>: <xsl:value-of select="/daten/person[1]/child::name" /><br />
 <b>/daten/person[1]/child::*</b>: <xsl:value-of select="/daten/person[1]/child::*" /><br />
 <b>/daten/person[1]/self::*</b>: <xsl:value-of select="/daten/person[1]/self::*" /><br />

<h4>Naviagtion im Baum</h4>
<table class="table" border="1">
<thead class="bold">
 <tr>
  <td>Eintrag</td>
  <td>Vorgnger</td>
  <td>Nachfolger</td>
  <td>Aktuell</td>
</tr>
</thead>
 <xsl:for-each select="//person">
  <tr class="aqua">
   <td><!-- ohne Achsen -->
        <b><xsl:value-of select="name/@anrede" />: </b>
         <xsl:value-of select="name" />, <xsl:value-of select="vorname"/><br /><hr  />
         <!-- mit Achsen -->
         <b><xsl:value-of select="name/attribute::anrede" />: </b>
         <xsl:value-of select="child::name" />, <xsl:value-of select="child::vorname"/>
   </td>
   <td class="lime" ><!-- mit Achse, Vorgnger -->
      <xsl:if test="position() >  1">
       <b><xsl:value-of select="preceding-sibling::person[1]/name"/>,  
       <xsl:value-of select="preceding-sibling::person[1]/vorname"/></b><hr />
       <!-- mit Achse, drei Vorgnger -->
         <xsl:value-of select="preceding::name[position() = 1]"/>,
         <xsl:value-of select="preceding::name[position() = 2]"/>, 
         <xsl:value-of select="preceding::name[position() = 3]"/>
     </xsl:if>
    </td>
   <td class="yellow"><!-- mit Achse, Nachfolger -->
      <xsl:if test="position() != last()">
          <xsl:value-of select="following-sibling::person[.]/name"/>,
          <xsl:value-of select="following-sibling::person[.]/vorname"/><hr />
         <xsl:value-of select="following::name[position() = 1]"/>, 
         <xsl:value-of select="following::name[position() = 2]"/>,
         <xsl:value-of select="following::name[position() = 3]"/>
    </xsl:if>
   </td>
   <td class="yellow">
          <b>node: <xsl:value-of select="name()" /></b><br />
          <b>ID: <xsl:value-of select="attribute::id" /> </b>
   </td>
 </tr>
</xsl:for-each>
</table>
</body>
</html>
</xsl:template>
</xsl:stylesheet>