<?xml version='1.0' encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl= "http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:template match="/">
  <html>
   <head>
     <title>XSL-Beispiel</title>
   <style>
    .bold   { font-weight: bold; }
    .yellow { background: yellow; }
    .table  { background-color: silver; }
    .lime   { background-color: lime; }
    .boldlime  { font-weight: bold; 
                 background-color: lime; }
   </style>
   </head>
   <body>
    <p class="bold">Namensliste aus XML-Dokument</p>
    <table border="1" class="table">
     <tr class="bold">
      <td>Nr.</td><!-- Leerzelle -->
      <td>Name</td>
      <td>Vorname</td>
      <td>Tel.Nr.</td>
     </tr> <!-- alle Personen -->
     <xsl:for-each select="//person" >
       <tr>
        <td class="boldlime">
         <xsl:number value="position()"/> | 
         <xsl:number value="position()" format="a"/>
        </td>
        <td class="boldlime">
         <xsl:value-of select="name"/>
        </td>
        <td class="lime">
         <xsl:value-of select="vorname"/>
        </td>
        <td class="yellow">
         <xsl:value-of select="tel"/>
        </td>
       </tr>
     </xsl:for-each>
    </table>
    <b>Datenstze: <xsl:value-of select="count(//person)" /></b>
   </body>
  </html>
</xsl:template>
</xsl:stylesheet>